/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.crypto;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.State;
import jpcsp.crypto.KIRK;
import jpcsp.crypto.KeyVault;
import jpcsp.format.PSF;
import jpcsp.util.Utilities;

public class SAVEDATA {
    private static KIRK kirk;
    private static final byte[] sdseed;

    public SAVEDATA() {
        kirk = new KIRK(sdseed, 20);
    }

    private static boolean isNullKey(byte[] key) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                if (key[i] == 0) continue;
                return false;
            }
        }
        return true;
    }

    private byte[] xorHash(byte[] dest, int dest_offset, int[] src, int src_offset, int size) {
        for (int i = 0; i < size; ++i) {
            dest[dest_offset + i] = (byte)(dest[dest_offset + i] ^ src[src_offset + i]);
        }
        return dest;
    }

    private byte[] xorKey(byte[] dest, int dest_offset, byte[] src, int src_offset, int size) {
        for (int i = 0; i < size; ++i) {
            dest[dest_offset + i] = (byte)(dest[dest_offset + i] ^ src[src_offset + i]);
        }
        return dest;
    }

    private void ScrambleSD(byte[] buf, int size, int seed, int cbc, int kirk_code) {
        Utilities.writeUnaligned32(buf, 0, cbc);
        Utilities.writeUnaligned32(buf, 4, 0);
        Utilities.writeUnaligned32(buf, 8, 0);
        Utilities.writeUnaligned32(buf, 12, seed);
        Utilities.writeUnaligned32(buf, 16, size);
        if (kirk_code == 5 || kirk_code == 8) {
            return;
        }
        ByteBuffer bBuf = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
        kirk.hleUtilsBufferCopyWithRange(bBuf, size, bBuf, size + 20, kirk_code);
    }

    private int getModeSeed(int mode) {
        int seed;
        switch (mode) {
            case 6: {
                seed = 17;
                break;
            }
            case 4: {
                seed = 13;
                break;
            }
            case 2: {
                seed = 5;
                break;
            }
            case 1: {
                seed = 3;
                break;
            }
            case 3: {
                seed = 12;
                break;
            }
            default: {
                seed = 16;
            }
        }
        return seed;
    }

    private void cryptMember(SD_Ctx2 ctx, byte[] data, int data_offset, int length) {
        int finalSeed;
        byte[] dataBuf = new byte[length + 20];
        byte[] keyBuf1 = new byte[16];
        byte[] keyBuf2 = new byte[16];
        byte[] hashBuf = new byte[16];
        System.arraycopy(ctx.buf, 0, dataBuf, 20, 16);
        if (ctx.mode == 1) {
            this.ScrambleSD(dataBuf, 16, 4, 5, 7);
            finalSeed = 83;
        } else if (ctx.mode == 2) {
            this.ScrambleSD(dataBuf, 16, 256, 5, 8);
            finalSeed = 83;
        } else if (ctx.mode == 3) {
            dataBuf = this.xorHash(dataBuf, 20, KeyVault.sdHashKey4, 0, 16);
            this.ScrambleSD(dataBuf, 16, 14, 5, 7);
            dataBuf = this.xorHash(dataBuf, 0, KeyVault.sdHashKey3, 0, 16);
            finalSeed = 87;
        } else if (ctx.mode == 4) {
            dataBuf = this.xorHash(dataBuf, 20, KeyVault.sdHashKey4, 0, 16);
            this.ScrambleSD(dataBuf, 16, 256, 5, 8);
            dataBuf = this.xorHash(dataBuf, 0, KeyVault.sdHashKey3, 0, 16);
            finalSeed = 87;
        } else if (ctx.mode == 6) {
            dataBuf = this.xorHash(dataBuf, 20, KeyVault.sdHashKey7, 0, 16);
            this.ScrambleSD(dataBuf, 16, 256, 5, 8);
            dataBuf = this.xorHash(dataBuf, 0, KeyVault.sdHashKey6, 0, 16);
            finalSeed = 100;
        } else {
            dataBuf = this.xorHash(dataBuf, 20, KeyVault.sdHashKey7, 0, 16);
            this.ScrambleSD(dataBuf, 16, 18, 5, 7);
            dataBuf = this.xorHash(dataBuf, 0, KeyVault.sdHashKey6, 0, 16);
            finalSeed = 100;
        }
        System.arraycopy(dataBuf, 0, keyBuf2, 0, 16);
        if (ctx.unk != 1) {
            System.arraycopy(keyBuf2, 0, keyBuf1, 0, 12);
            keyBuf1[12] = (byte)(ctx.unk - 1 & 0xFF);
            keyBuf1[13] = (byte)(ctx.unk - 1 >> 8 & 0xFF);
            keyBuf1[14] = (byte)(ctx.unk - 1 >> 16 & 0xFF);
            keyBuf1[15] = (byte)(ctx.unk - 1 >> 24 & 0xFF);
        }
        for (int i = 20; i < length + 20; i += 16) {
            System.arraycopy(keyBuf2, 0, dataBuf, i, 12);
            dataBuf[i + 12] = (byte)(ctx.unk & 0xFF);
            dataBuf[i + 13] = (byte)(ctx.unk >> 8 & 0xFF);
            dataBuf[i + 14] = (byte)(ctx.unk >> 16 & 0xFF);
            dataBuf[i + 15] = (byte)(ctx.unk >> 24 & 0xFF);
            ctx.unk++;
        }
        System.arraycopy(dataBuf, length + 4, hashBuf, 0, 16);
        this.ScrambleSD(dataBuf, length, finalSeed, 5, 7);
        dataBuf = this.xorKey(dataBuf, 0, keyBuf1, 0, 16);
        System.arraycopy(hashBuf, 0, keyBuf1, 0, 16);
        this.xorKey(data, data_offset, dataBuf, 0, length);
    }

    public int hleSdSetIndex(SD_Ctx1 ctx, int encMode) {
        int i;
        ctx.mode = encMode;
        ctx.padSize = 0;
        for (i = 0; i < 16; ++i) {
            ctx.pad[i] = 0;
        }
        for (i = 0; i < 16; ++i) {
            ctx.key[i] = 0;
        }
        return 0;
    }

    public int hleSdRemoveValue(SD_Ctx1 ctx, byte[] data, int length) {
        if (ctx.padSize > 16 || length < 0) {
            return -1;
        }
        if (ctx.padSize + length <= 16) {
            System.arraycopy(data, 0, ctx.pad, ctx.padSize, length);
            ctx.padSize += length;
            return 0;
        }
        int seed = this.getModeSeed(ctx.mode);
        byte[] scrambleBuf = new byte[2068];
        System.arraycopy(ctx.pad, 0, scrambleBuf, 20, ctx.padSize);
        int kLen = ctx.padSize + length & 0xF;
        if (kLen == 0) {
            kLen = 16;
        }
        int nLen = ctx.padSize;
        ctx.padSize = kLen;
        int remaining = length - kLen;
        System.arraycopy(data, remaining, ctx.pad, 0, kLen);
        int blockSize = 2048;
        for (int i = 0; i < remaining; ++i) {
            if (nLen == blockSize) {
                scrambleBuf = this.xorKey(scrambleBuf, 20, ctx.key, 0, 16);
                this.ScrambleSD(scrambleBuf, blockSize, seed, 4, 4);
                System.arraycopy(scrambleBuf, blockSize + 4, ctx.key, 0, 16);
                nLen = 0;
            }
            scrambleBuf[20 + nLen] = data[i];
            ++nLen;
        }
        if (nLen > 0) {
            scrambleBuf = this.xorKey(scrambleBuf, 20, ctx.key, 0, 16);
            this.ScrambleSD(scrambleBuf, nLen, seed, 4, 4);
            System.arraycopy(scrambleBuf, nLen + 4, ctx.key, 0, 16);
        }
        return 0;
    }

    public int hleSdGetLastIndex(SD_Ctx1 ctx, byte[] hash, byte[] key) {
        int i;
        if (ctx.padSize > 16) {
            return -1;
        }
        int seed = this.getModeSeed(ctx.mode);
        byte[] scrambleBuf = new byte[2068];
        byte[] keyBuf = new byte[16];
        byte[] resultBuf = new byte[16];
        this.ScrambleSD(scrambleBuf, 16, seed, 4, 4);
        System.arraycopy(scrambleBuf, 20, keyBuf, 0, 16);
        int b = (keyBuf[0] & 0xFFFFFF80) != 0 ? -121 : 0;
        for (int i2 = 0; i2 < 15; ++i2) {
            int b1 = (keyBuf[i2] & 0xFF) << 1;
            int b2 = (keyBuf[i2 + 1] & 0xFF) >> 7;
            keyBuf[i2] = (byte)(b1 | b2);
        }
        byte t = (byte)((keyBuf[15] & 0xFF) << 1);
        keyBuf[15] = (byte)(t ^ b);
        if (ctx.padSize < 16) {
            int bb = keyBuf[0] < 0 ? -121 : 0;
            for (int i3 = 0; i3 < 15; ++i3) {
                int bb1 = (keyBuf[i3] & 0xFF) << 1;
                int bb2 = (keyBuf[i3 + 1] & 0xFF) >> 7;
                keyBuf[i3] = (byte)(bb1 | bb2);
            }
            byte tt = (byte)((keyBuf[15] & 0xFF) << 1);
            keyBuf[15] = (byte)(tt ^ bb);
            ctx.pad[ctx.padSize] = -128;
            if (ctx.padSize + 1 < 16) {
                for (int i4 = 0; i4 < 16 - ctx.padSize - 1; ++i4) {
                    ctx.pad[ctx.padSize + 1 + i4] = 0;
                }
            }
        }
        ctx.pad = this.xorKey(ctx.pad, 0, keyBuf, 0, 16);
        System.arraycopy(ctx.pad, 0, scrambleBuf, 20, 16);
        System.arraycopy(ctx.key, 0, resultBuf, 0, 16);
        scrambleBuf = this.xorKey(scrambleBuf, 20, resultBuf, 0, 16);
        this.ScrambleSD(scrambleBuf, 16, seed, 4, 4);
        System.arraycopy(scrambleBuf, 20, resultBuf, 0, 16);
        if (ctx.mode == 5 || ctx.mode == 6) {
            resultBuf = this.xorHash(resultBuf, 0, KeyVault.sdHashKey5, 0, 16);
        } else if (ctx.mode == 3 || ctx.mode == 4) {
            resultBuf = this.xorHash(resultBuf, 0, KeyVault.sdHashKey2, 0, 16);
        }
        if (ctx.mode == 2 || ctx.mode == 4 || ctx.mode == 6) {
            System.arraycopy(resultBuf, 0, scrambleBuf, 20, 16);
            this.ScrambleSD(scrambleBuf, 16, 256, 4, 5);
            this.ScrambleSD(scrambleBuf, 16, seed, 4, 4);
            System.arraycopy(scrambleBuf, 20, resultBuf, 0, 16);
        }
        if (key != null) {
            resultBuf = this.xorKey(resultBuf, 0, key, 0, 16);
            System.arraycopy(resultBuf, 0, scrambleBuf, 20, 16);
            this.ScrambleSD(scrambleBuf, 16, seed, 4, 4);
            System.arraycopy(scrambleBuf, 20, resultBuf, 0, 16);
        }
        System.arraycopy(resultBuf, 0, hash, 0, 16);
        ctx.mode = 0;
        ctx.padSize = 0;
        for (i = 0; i < 16; ++i) {
            ctx.pad[i] = 0;
        }
        for (i = 0; i < 16; ++i) {
            ctx.key[i] = 0;
        }
        return 0;
    }

    public int hleSdCleanList(SD_Ctx2 ctx) {
        ctx.mode = 0;
        ctx.unk = 0;
        for (int i = 0; i < 16; ++i) {
            ((SD_Ctx2)ctx).buf[i] = 0;
        }
        return 0;
    }

    public int hleSdCreateList(SD_Ctx2 ctx, int encMode, int genMode, byte[] data, byte[] key) {
        if (!SAVEDATA.isNullKey(key) && key.length < 16) {
            return -1;
        }
        ctx.mode = encMode;
        ctx.unk = 1;
        if (genMode == 1) {
            byte[] header = new byte[36];
            byte[] seed = new byte[20];
            ByteBuffer bSeed = ByteBuffer.wrap(seed).order(ByteOrder.LITTLE_ENDIAN);
            kirk.hleUtilsBufferCopyWithRange(bSeed, 20, null, 0, 14);
            System.arraycopy(bSeed.array(), 0, header, 0, 20);
            System.arraycopy(bSeed.array(), 0, header, 20, 16);
            header[32] = 0;
            header[33] = 0;
            header[34] = 0;
            header[35] = 0;
            if (ctx.mode == 1) {
                this.ScrambleSD(header, 16, 4, 4, 4);
                System.arraycopy(header, 20, ctx.buf, 0, 16);
                System.arraycopy(header, 20, data, 0, 16);
                if (!SAVEDATA.isNullKey(key)) {
                    SD_Ctx2.access$002(ctx, this.xorKey(ctx.buf, 0, key, 0, 16));
                }
                return 0;
            }
            if (ctx.mode == 2) {
                this.ScrambleSD(header, 16, 256, 4, 5);
                System.arraycopy(header, 20, ctx.buf, 0, 16);
                System.arraycopy(header, 20, data, 0, 16);
                if (!SAVEDATA.isNullKey(key)) {
                    SD_Ctx2.access$002(ctx, this.xorKey(ctx.buf, 0, key, 0, 16));
                }
                return 0;
            }
            if (ctx.mode == 3) {
                header = this.xorHash(header, 20, KeyVault.sdHashKey3, 0, 16);
                this.ScrambleSD(header, 16, 14, 4, 4);
                header = this.xorHash(header, 20, KeyVault.sdHashKey4, 0, 16);
                System.arraycopy(header, 20, ctx.buf, 0, 16);
                System.arraycopy(header, 20, data, 0, 16);
                if (!SAVEDATA.isNullKey(key)) {
                    SD_Ctx2.access$002(ctx, this.xorKey(ctx.buf, 0, key, 0, 16));
                }
                return 0;
            }
            if (ctx.mode == 4) {
                header = this.xorHash(header, 20, KeyVault.sdHashKey3, 0, 16);
                this.ScrambleSD(header, 16, 256, 4, 5);
                header = this.xorHash(header, 20, KeyVault.sdHashKey4, 0, 16);
                System.arraycopy(header, 20, ctx.buf, 0, 16);
                System.arraycopy(header, 20, data, 0, 16);
                if (!SAVEDATA.isNullKey(key)) {
                    SD_Ctx2.access$002(ctx, this.xorKey(ctx.buf, 0, key, 0, 16));
                }
                return 0;
            }
            if (ctx.mode == 6) {
                header = this.xorHash(header, 20, KeyVault.sdHashKey6, 0, 16);
                this.ScrambleSD(header, 16, 256, 4, 5);
                header = this.xorHash(header, 20, KeyVault.sdHashKey7, 0, 16);
                System.arraycopy(header, 20, ctx.buf, 0, 16);
                System.arraycopy(header, 20, data, 0, 16);
                if (!SAVEDATA.isNullKey(key)) {
                    SD_Ctx2.access$002(ctx, this.xorKey(ctx.buf, 0, key, 0, 16));
                }
                return 0;
            }
            header = this.xorHash(header, 20, KeyVault.sdHashKey6, 0, 16);
            this.ScrambleSD(header, 16, 18, 4, 4);
            header = this.xorHash(header, 20, KeyVault.sdHashKey7, 0, 16);
            System.arraycopy(header, 20, ctx.buf, 0, 16);
            System.arraycopy(header, 20, data, 0, 16);
            if (!SAVEDATA.isNullKey(key)) {
                SD_Ctx2.access$002(ctx, this.xorKey(ctx.buf, 0, key, 0, 16));
            }
            return 0;
        }
        if (genMode == 2) {
            System.arraycopy(data, 0, ctx.buf, 0, 16);
            if (!SAVEDATA.isNullKey(key)) {
                SD_Ctx2.access$002(ctx, this.xorKey(ctx.buf, 0, key, 0, 16));
            }
            return 0;
        }
        return -1;
    }

    public int hleSdSetMember(SD_Ctx2 ctx, byte[] data, int length) {
        if (length == 0) {
            return 0;
        }
        if ((length & 0xF) != 0) {
            return -1;
        }
        int index = 0;
        if (length >= 2048) {
            index = 0;
            while (length >= 2048) {
                this.cryptMember(ctx, data, index, 2048);
                length -= 2048;
                index += 2048;
            }
        }
        if (length >= 16) {
            this.cryptMember(ctx, data, index, length);
        }
        return 0;
    }

    public byte[] DecryptSavedata(byte[] buf, int size, byte[] key) {
        SD_Ctx1 ctx1 = new SD_Ctx1();
        SD_Ctx2 ctx2 = new SD_Ctx2();
        int alignedSize = (size + 15 >> 4 << 4) - 16;
        byte[] decbuf = new byte[size - 16];
        byte[] tmpbuf = new byte[alignedSize];
        int sdDecMode = SAVEDATA.isNullKey(key) ? 1 : (Emulator.getInstance().getFirmwareVersion() > 271 && !State.discId.equals("ULUS10195") && !State.discId.equals("ULES00622") && !State.discId.equals("ULUS10193") && !State.discId.equals("ULES00608") && !State.discId.equals("ULUS10150") && !State.discId.equals("ULES00623") ? 5 : 3);
        this.hleSdSetIndex(ctx1, sdDecMode);
        this.hleSdCreateList(ctx2, sdDecMode, 2, buf, key);
        this.hleSdRemoveValue(ctx1, buf, 16);
        System.arraycopy(buf, 16, tmpbuf, 0, size - 16);
        this.hleSdRemoveValue(ctx1, tmpbuf, alignedSize);
        this.hleSdSetMember(ctx2, tmpbuf, alignedSize);
        this.hleSdCleanList(ctx2);
        System.arraycopy(tmpbuf, 0, decbuf, 0, size - 16);
        return decbuf;
    }

    public byte[] EncryptSavedata(byte[] buf, int size, byte[] key) {
        int i;
        SD_Ctx1 ctx1 = new SD_Ctx1();
        SD_Ctx2 ctx2 = new SD_Ctx2();
        int alignedSize = size + 15 >> 4 << 4;
        byte[] tmpbuf1 = new byte[alignedSize + 16];
        byte[] tmpbuf2 = new byte[alignedSize];
        byte[] hash = new byte[16];
        System.arraycopy(buf, 0, tmpbuf1, 16, size);
        int sdEncMode = SAVEDATA.isNullKey(key) ? 1 : (Emulator.getInstance().getFirmwareVersion() > 271 && !State.discId.equals("ULUS10195") && !State.discId.equals("ULES00622") && !State.discId.equals("ULUS10193") && !State.discId.equals("ULES00608") && !State.discId.equals("ULUS10150") && !State.discId.equals("ULES00623") ? 5 : 3);
        this.hleSdCreateList(ctx2, sdEncMode, 1, tmpbuf1, key);
        this.hleSdSetIndex(ctx1, sdEncMode);
        this.hleSdRemoveValue(ctx1, tmpbuf1, 16);
        System.arraycopy(tmpbuf1, 16, tmpbuf2, 0, alignedSize);
        this.hleSdSetMember(ctx2, tmpbuf2, alignedSize);
        for (i = 0; i < alignedSize - size; ++i) {
            tmpbuf2[size + i] = 0;
        }
        this.hleSdRemoveValue(ctx1, tmpbuf2, alignedSize);
        for (i = 0; i < tmpbuf1.length - 16; ++i) {
            tmpbuf1[16 + i] = 0;
        }
        System.arraycopy(tmpbuf2, 0, tmpbuf1, 16, alignedSize);
        System.arraycopy(tmpbuf1, 0, buf, 0, buf.length);
        this.hleSdCleanList(ctx2);
        this.hleSdGetLastIndex(ctx1, hash, key);
        return hash;
    }

    private byte[] GenerateSavedataHash(byte[] data, int size, int mode) {
        SD_Ctx1 ctx1 = new SD_Ctx1();
        byte[] hash = new byte[16];
        this.hleSdSetIndex(ctx1, mode);
        this.hleSdRemoveValue(ctx1, data, size);
        if (this.hleSdGetLastIndex(ctx1, hash, null) < 0) {
            for (int i = 0; i < 16; ++i) {
                hash[i] = 1;
            }
        }
        return hash;
    }

    public void UpdateSavedataHashes(PSF psf, byte[] data, int size, byte[] params, byte[] key) {
        byte[] hash = new byte[16];
        int mode = 0;
        int check_bit = 1;
        if (!SAVEDATA.isNullKey(key)) {
            mode = Emulator.getInstance().getFirmwareVersion() > 271 ? 4 : 2;
        }
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == 0) continue;
                mode = params[0] >> 4 & 0xF;
                check_bit = params[0] & 0xF;
                break;
            }
        }
        if ((mode & 4) == 4) {
            hash = this.GenerateSavedataHash(data, size, 6);
            System.arraycopy(hash, 0, data, 4560, 16);
            data[4528] = (byte)(data[4528] | 1);
            data[4528] = (byte)(data[4528] | 0x40);
            hash = this.GenerateSavedataHash(data, size, 5);
            System.arraycopy(hash, 0, data, 4640, 16);
        } else if ((mode & 2) == 2) {
            hash = this.GenerateSavedataHash(data, size, 4);
            System.arraycopy(hash, 0, data, 4560, 16);
            data[4528] = (byte)(data[4528] | 1);
            data[4528] = (byte)(data[4528] | 0x20);
            hash = this.GenerateSavedataHash(data, size, 3);
            System.arraycopy(hash, 0, data, 4640, 16);
        } else {
            hash = this.GenerateSavedataHash(data, size, 2);
            System.arraycopy(hash, 0, data, 4560, 16);
            data[4528] = (byte)(data[4528] | 1);
        }
        if ((check_bit & 1) == 1) {
            hash = this.GenerateSavedataHash(data, size, 1);
            System.arraycopy(hash, 0, data, 4544, 16);
        }
        try {
            byte[] savedataParams = new byte[128];
            for (int i = 0; i < 128; ++i) {
                savedataParams[i] = data[4528 + i];
            }
            psf.put("SAVEDATA_PARAMS", savedataParams);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        sdseed = new byte[]{83, 65, 86, 69, 68, 65, 84, 65, 83, 69, 69, 68, 74, 80, 67, 83, 80, 48, 48, 48};
    }

    public static class SD_Ctx2
    extends pspAbstractMemoryMappedStructure {
        private int mode = 0;
        private int unk = 0;
        private byte[] buf = new byte[16];

        @Override
        protected void read() {
            this.mode = this.read32();
            this.unk = this.read32();
            this.read8Array(this.buf);
        }

        @Override
        protected void write() {
            this.write32(this.mode);
            this.write32(this.unk);
            this.write8Array(this.buf);
        }

        @Override
        public int sizeof() {
            return 24;
        }

        @Override
        public String toString() {
            return String.format("mode=0x%X, unk=0x%X, buf=%s", this.mode, this.unk, Utilities.getMemoryDump(this.buf, 0, this.buf.length));
        }

        static /* synthetic */ byte[] access$002(SD_Ctx2 x0, byte[] x1) {
            x0.buf = x1;
            return x1;
        }
    }

    public static class SD_Ctx1
    extends pspAbstractMemoryMappedStructure {
        public int mode;
        public byte[] pad = new byte[16];
        public byte[] key = new byte[16];
        public int padSize;

        @Override
        protected void read() {
            this.mode = this.read32();
            this.read8Array(this.pad);
            this.read8Array(this.key);
            this.padSize = this.read32();
        }

        @Override
        protected void write() {
            this.write32(this.mode);
            this.write8Array(this.pad);
            this.write8Array(this.key);
            this.write32(this.padSize);
        }

        @Override
        public int sizeof() {
            return 40;
        }

        @Override
        public String toString() {
            return String.format("mode=0x%X, pad=%s, key=%s, padSize=0x%X", this.mode, Utilities.getMemoryDump(this.pad, 0, this.pad.length), Utilities.getMemoryDump(this.key, 0, this.key.length), this.padSize);
        }
    }
}

